/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.util.CryptoKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDataSource
extends DataSource<Iterator<Map<String, Object>>> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Callable<Connection> factory;
    private long connLastUsed = 0L;
    private Connection conn;
    private ResultSetIterator resultSetIterator;
    private Map<String, Integer> fieldNameVsType = new HashMap<String, Integer>();
    private boolean convertType = false;
    private int batchSize = 500;
    private int maxRows = 0;
    private boolean isClosed = false;
    private static final long CONN_TIME_OUT = TimeUnit.NANOSECONDS.convert(10L, TimeUnit.SECONDS);
    private static final int FETCH_SIZE = 500;
    public static final String URL = "url";
    public static final String JNDI_NAME = "jndiName";
    public static final String DRIVER = "driver";
    public static final String CONVERT_TYPE = "convertType";

    @Override
    public void init(Context context, Properties initProps) {
        this.resolveVariables(context, initProps);
        initProps = this.decryptPwd(context, initProps);
        Object o = initProps.get(CONVERT_TYPE);
        if (o != null) {
            this.convertType = Boolean.parseBoolean(o.toString());
        }
        this.factory = this.createConnectionFactory(context, initProps);
        String bsz = initProps.getProperty("batchSize");
        if (bsz != null) {
            bsz = context.replaceTokens(bsz);
            try {
                this.batchSize = Integer.parseInt(bsz);
                if (this.batchSize == -1) {
                    this.batchSize = Integer.MIN_VALUE;
                }
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid batch size: " + bsz);
            }
        }
        for (Map<String, String> map : context.getAllEntityFields()) {
            String n = map.get("column");
            String t = map.get("type");
            if ("sint".equals(t) || "integer".equals(t)) {
                this.fieldNameVsType.put(n, 4);
                continue;
            }
            if ("slong".equals(t) || "long".equals(t)) {
                this.fieldNameVsType.put(n, -5);
                continue;
            }
            if ("float".equals(t) || "sfloat".equals(t)) {
                this.fieldNameVsType.put(n, 6);
                continue;
            }
            if ("double".equals(t) || "sdouble".equals(t)) {
                this.fieldNameVsType.put(n, 8);
                continue;
            }
            if ("date".equals(t)) {
                this.fieldNameVsType.put(n, 91);
                continue;
            }
            if ("boolean".equals(t)) {
                this.fieldNameVsType.put(n, 16);
                continue;
            }
            if ("binary".equals(t)) {
                this.fieldNameVsType.put(n, 2004);
                continue;
            }
            this.fieldNameVsType.put(n, 12);
        }
    }

    private Properties decryptPwd(Context context, Properties initProps) {
        String encryptionKey = initProps.getProperty("encryptKeyFile");
        if (initProps.getProperty("password") != null && encryptionKey != null) {
            try (InputStreamReader fr = new InputStreamReader((InputStream)new FileInputStream(encryptionKey), StandardCharsets.UTF_8);){
                char[] chars = new char[100];
                int len = fr.read(chars);
                if (len < 6) {
                    throw new DataImportHandlerException(500, "There should be a password of length 6 atleast " + encryptionKey);
                }
                Properties props = new Properties();
                props.putAll((Map<?, ?>)initProps);
                String password = null;
                try {
                    password = CryptoKeys.decodeAES((String)initProps.getProperty("password"), (String)new String(chars, 0, len)).trim();
                }
                catch (SolrException se) {
                    throw new DataImportHandlerException(500, "Error decoding password", se.getCause());
                }
                props.put("password", password);
                initProps = props;
            }
            catch (IOException e) {
                throw new DataImportHandlerException(500, "Could not load encryptKeyFile  " + encryptionKey);
            }
        }
        return initProps;
    }

    protected Callable<Connection> createConnectionFactory(final Context context, final Properties initProps) {
        String s;
        final String jndiName = initProps.getProperty(JNDI_NAME);
        final String url = initProps.getProperty(URL);
        final String driver = initProps.getProperty(DRIVER);
        if (url == null && jndiName == null) {
            throw new DataImportHandlerException(500, "JDBC URL or JNDI name has to be specified");
        }
        if (driver != null) {
            try {
                DocBuilder.loadClass(driver, context.getSolrCore());
            }
            catch (ClassNotFoundException e) {
                DataImportHandlerException.wrapAndThrow(500, e, "Could not load driver: " + driver);
            }
        } else if (jndiName == null) {
            throw new DataImportHandlerException(500, "One of driver or jndiName must be specified in the data source");
        }
        if ((s = initProps.getProperty("maxRows")) != null) {
            this.maxRows = Integer.parseInt(s);
        }
        this.factory = new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                LOG.info("Creating a connection for entity " + context.getEntityAttribute("name") + " with URL: " + url);
                long start = System.nanoTime();
                Connection c = null;
                if (jndiName != null) {
                    c = this.getFromJndi(initProps, jndiName);
                } else if (url != null) {
                    try {
                        c = DriverManager.getConnection(url, initProps);
                    }
                    catch (SQLException e) {
                        Driver d = (Driver)DocBuilder.loadClass(driver, context.getSolrCore()).newInstance();
                        c = d.connect(url, initProps);
                    }
                }
                if (c != null) {
                    try {
                        this.initializeConnection(c, initProps);
                    }
                    catch (SQLException e) {
                        try {
                            c.close();
                        }
                        catch (SQLException e2) {
                            LOG.warn("Exception closing connection during cleanup", (Throwable)e2);
                        }
                        throw new DataImportHandlerException(500, "Exception initializing SQL connection", e);
                    }
                }
                LOG.info("Time taken for getConnection(): " + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                return c;
            }

            private void initializeConnection(Connection c, Properties initProps2) throws SQLException {
                String transactionIsolation;
                if (Boolean.parseBoolean(initProps2.getProperty("readOnly"))) {
                    c.setReadOnly(true);
                    c.setAutoCommit(true);
                    c.setTransactionIsolation(1);
                    c.setHoldability(2);
                }
                if (!Boolean.parseBoolean(initProps2.getProperty("autoCommit"))) {
                    c.setAutoCommit(false);
                }
                if ("TRANSACTION_READ_UNCOMMITTED".equals(transactionIsolation = initProps2.getProperty("transactionIsolation"))) {
                    c.setTransactionIsolation(1);
                } else if ("TRANSACTION_READ_COMMITTED".equals(transactionIsolation)) {
                    c.setTransactionIsolation(2);
                } else if ("TRANSACTION_REPEATABLE_READ".equals(transactionIsolation)) {
                    c.setTransactionIsolation(4);
                } else if ("TRANSACTION_SERIALIZABLE".equals(transactionIsolation)) {
                    c.setTransactionIsolation(8);
                } else if ("TRANSACTION_NONE".equals(transactionIsolation)) {
                    c.setTransactionIsolation(0);
                }
                String holdability = initProps2.getProperty("holdability");
                if ("CLOSE_CURSORS_AT_COMMIT".equals(holdability)) {
                    c.setHoldability(2);
                } else if ("HOLD_CURSORS_OVER_COMMIT".equals(holdability)) {
                    c.setHoldability(1);
                }
            }

            private Connection getFromJndi(Properties initProps2, String jndiName2) throws NamingException, SQLException {
                Connection c = null;
                InitialContext ctx = new InitialContext();
                Object jndival = ctx.lookup(jndiName2);
                if (jndival instanceof javax.sql.DataSource) {
                    javax.sql.DataSource dataSource = (javax.sql.DataSource)jndival;
                    String user = (String)initProps2.get("user");
                    String pass = (String)initProps2.get("password");
                    c = user == null || user.trim().equals("") ? dataSource.getConnection() : dataSource.getConnection(user, pass);
                } else {
                    throw new DataImportHandlerException(500, "the jndi name : '" + jndiName2 + "' is not a valid javax.sql.DataSource");
                }
                return c;
            }
        };
        return this.factory;
    }

    private void resolveVariables(Context ctx, Properties initProps) {
        for (Map.Entry<Object, Object> entry : initProps.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.setValue(ctx.replaceTokens((String)entry.getValue()));
        }
    }

    @Override
    public Iterator<Map<String, Object>> getData(String query) {
        if (this.resultSetIterator != null) {
            this.resultSetIterator.close();
            this.resultSetIterator = null;
        }
        this.resultSetIterator = this.createResultSetIterator(query);
        return this.resultSetIterator.getIterator();
    }

    protected ResultSetIterator createResultSetIterator(String query) {
        return new ResultSetIterator(query);
    }

    private void logError(String msg, Exception e) {
        LOG.warn(msg, (Throwable)e);
    }

    protected List<String> readFieldNames(ResultSetMetaData metaData) throws SQLException {
        ArrayList<String> colNames = new ArrayList<String>();
        int count = metaData.getColumnCount();
        for (int i = 0; i < count; ++i) {
            colNames.add(metaData.getColumnLabel(i + 1));
        }
        return colNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection() throws Exception {
        long currTime = System.nanoTime();
        if (currTime - this.connLastUsed > CONN_TIME_OUT) {
            JdbcDataSource jdbcDataSource = this;
            synchronized (jdbcDataSource) {
                Connection tmpConn = this.factory.call();
                this.closeConnection();
                this.connLastUsed = System.nanoTime();
                this.conn = tmpConn;
                return this.conn;
            }
        }
        this.connLastUsed = currTime;
        return this.conn;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed) {
                LOG.error("JdbcDataSource was not closed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        if (this.resultSetIterator != null) {
            this.resultSetIterator.close();
        }
        try {
            this.closeConnection();
        }
        finally {
            this.isClosed = true;
        }
    }

    private void closeConnection() {
        block4: {
            try {
                if (this.conn == null) break block4;
                try {
                    this.conn.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.conn.close();
            }
            catch (Exception e) {
                LOG.error("Ignoring Error when closing connection", (Throwable)e);
            }
        }
    }

    protected class ResultSetIterator {
        private ResultSet resultSet;
        private Statement stmt = null;
        private List<String> colNames;
        private Iterator<Map<String, Object>> rSetIterator;

        public ResultSetIterator(String query) {
            try {
                Connection c = JdbcDataSource.this.getConnection();
                this.stmt = this.createStatement(c, JdbcDataSource.this.batchSize, JdbcDataSource.this.maxRows);
                LOG.debug("Executing SQL: " + query);
                long start = System.nanoTime();
                this.resultSet = this.executeStatement(this.stmt, query);
                LOG.trace("Time taken for sql :" + TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
                this.setColNames(this.resultSet);
            }
            catch (Exception e) {
                this.close();
                DataImportHandlerException.wrapAndThrow(500, e, "Unable to execute query: " + query);
                return;
            }
            if (this.resultSet == null) {
                this.close();
                this.rSetIterator = new ArrayList().iterator();
                return;
            }
            this.rSetIterator = this.createIterator(JdbcDataSource.this.convertType, JdbcDataSource.this.fieldNameVsType);
        }

        protected Statement createStatement(Connection c, int batchSize, int maxRows) throws SQLException {
            Statement statement = c.createStatement(1003, 1007);
            statement.setFetchSize(batchSize);
            statement.setMaxRows(maxRows);
            return statement;
        }

        protected ResultSet executeStatement(Statement statement, String query) throws SQLException {
            boolean resultSetReturned = statement.execute(query);
            return this.getNextResultSet(resultSetReturned, statement);
        }

        protected ResultSet getNextResultSet(boolean initialResultSetAvailable, Statement statement) throws SQLException {
            boolean resultSetAvailable = initialResultSetAvailable;
            while (!resultSetAvailable && statement.getUpdateCount() != -1) {
                resultSetAvailable = statement.getMoreResults();
            }
            if (resultSetAvailable) {
                return statement.getResultSet();
            }
            return null;
        }

        protected void setColNames(ResultSet resultSet) throws SQLException {
            this.colNames = resultSet != null ? JdbcDataSource.this.readFieldNames(resultSet.getMetaData()) : Collections.emptyList();
        }

        protected Iterator<Map<String, Object>> createIterator(final boolean convertType, final Map<String, Integer> fieldNameVsType) {
            return new Iterator<Map<String, Object>>(){

                @Override
                public boolean hasNext() {
                    return ResultSetIterator.this.hasnext();
                }

                @Override
                public Map<String, Object> next() {
                    return ResultSetIterator.this.getARow(convertType, fieldNameVsType);
                }

                @Override
                public void remove() {
                }
            };
        }

        protected Map<String, Object> getARow(boolean convertType, Map<String, Integer> fieldNameVsType) {
            if (this.getResultSet() == null) {
                return null;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String colName : this.getColNames()) {
                try {
                    if (!convertType) {
                        Object value = this.getResultSet().getObject(colName);
                        if (value instanceof BigDecimal || value instanceof BigInteger) {
                            result.put(colName, value.toString());
                            continue;
                        }
                        result.put(colName, value);
                        continue;
                    }
                    Integer type = fieldNameVsType.get(colName);
                    if (type == null) {
                        type = 12;
                    }
                    switch (type) {
                        case 4: {
                            result.put(colName, this.getResultSet().getInt(colName));
                            break;
                        }
                        case 6: {
                            result.put(colName, Float.valueOf(this.getResultSet().getFloat(colName)));
                            break;
                        }
                        case -5: {
                            result.put(colName, this.getResultSet().getLong(colName));
                            break;
                        }
                        case 8: {
                            result.put(colName, this.getResultSet().getDouble(colName));
                            break;
                        }
                        case 91: {
                            result.put(colName, this.getResultSet().getTimestamp(colName));
                            break;
                        }
                        case 16: {
                            result.put(colName, this.getResultSet().getBoolean(colName));
                            break;
                        }
                        case 2004: {
                            result.put(colName, this.getResultSet().getBytes(colName));
                            break;
                        }
                        default: {
                            result.put(colName, this.getResultSet().getString(colName));
                            break;
                        }
                    }
                }
                catch (SQLException e) {
                    JdbcDataSource.this.logError("Error reading data ", e);
                    DataImportHandlerException.wrapAndThrow(500, e, "Error reading data from database");
                }
            }
            return result;
        }

        protected boolean hasnext() {
            if (this.getResultSet() == null) {
                this.close();
                return false;
            }
            try {
                if (this.getResultSet().next()) {
                    return true;
                }
                this.closeResultSet();
                this.setResultSet(this.getNextResultSet(this.getStatement().getMoreResults(), this.getStatement()));
                this.setColNames(this.getResultSet());
                return this.hasnext();
            }
            catch (SQLException e) {
                this.close();
                DataImportHandlerException.wrapAndThrow(500, e);
                return false;
            }
        }

        protected void close() {
            this.closeResultSet();
            try {
                if (this.getStatement() != null) {
                    this.getStatement().close();
                }
            }
            catch (Exception e) {
                JdbcDataSource.this.logError("Exception while closing statement", e);
            }
            finally {
                this.setStatement(null);
            }
        }

        protected void closeResultSet() {
            try {
                if (this.getResultSet() != null) {
                    this.getResultSet().close();
                }
            }
            catch (Exception e) {
                JdbcDataSource.this.logError("Exception while closing result set", e);
            }
            finally {
                this.setResultSet(null);
            }
        }

        protected final Iterator<Map<String, Object>> getIterator() {
            return this.rSetIterator;
        }

        protected final Statement getStatement() {
            return this.stmt;
        }

        protected final void setStatement(Statement stmt) {
            this.stmt = stmt;
        }

        protected final ResultSet getResultSet() {
            return this.resultSet;
        }

        protected final void setResultSet(ResultSet resultSet) {
            this.resultSet = resultSet;
        }

        protected final List<String> getColNames() {
            return this.colNames;
        }

        protected final void setColNames(List<String> colNames) {
            this.colNames = colNames;
        }
    }
}

